;define(function (require, exports, module) {
	var jQuery  = require('jquery');

/**
 * @DOM
 *  	<div id="marquee">
 *  		<ul>
 *   			<li></li>
 *   			<li></li>
 *  		</ul>
 *  	</div>
 * @CSS
 *  	#marquee {overflow:hidden;width:200px;height:50px;}
 * @Usage
 *  	$("#marquee").aliziMarquee(options);
 * @options
 *		isEqual:true,		//йԪسǷ,true,false
 *  	loop:0,				//ѭ0ʱ
 *		direction:"left",	//"left","right","up","down"
 *		scrollAmount:1,		//
 *		scrollDelay:20		//ʱ
 */
(function ($) {
    $.fn.aliziMarquee = function (options) {
        var opts = $.extend({}, $.fn.aliziMarquee.defaults, options);

        return this.each(function () {
            var $marquee = $(this);				//Ԫ
            var _scrollObj = $marquee.get(0);		//ԪDOM
            var scrollW = $marquee.width();		//ԪĿ
            var scrollH = $marquee.height();		//Ԫĸ߶
            var $element = $marquee.children();	//Ԫ
            var $kids = $element.children();		//Ԫ
            var scrollSize = 0;					//Ԫسߴ

            //ͣ1ң0
            var _type = (opts.direction == "left" || opts.direction == "right") ? 1 : 0;

            //ֹԪرȹԪؿȡʵʹԪؿ
            $element.css(_type ? "width" : "height", 10000);

            //ȡԪصĳߴ
            if (opts.isEqual) {
                scrollSize = $kids[_type ? "outerWidth" : "outerHeight"]() * $kids.length;
            } else {
                $kids.each(function () {
                    scrollSize += $(this)[_type ? "outerWidth" : "outerHeight"]();
                });
            };

            //ԪܳߴСߴ磬
            if (scrollSize < (_type ? scrollW : scrollH)) { return; };

            //¡Ԫؽ뵽Ԫغ󣬲趨Ԫؿ
            $element.append($kids.clone()).css(_type ? "width" : "height", scrollSize * 2);

            var numMoved = 0;
            function scrollFunc() {
                var _dir = (opts.direction == "left" || opts.direction == "right") ? "scrollLeft" : "scrollTop";
                if (opts.loop > 0) {
                    numMoved += opts.scrollAmount;
                    if (numMoved > scrollSize * opts.loop) {
                        _scrollObj[_dir] = 0;
                        return clearInterval(moveId);
                    };
                };

                if (opts.direction == "left" || opts.direction == "up") {
                    var newPos = _scrollObj[_dir] + opts.scrollAmount;
                    if (newPos >= scrollSize) {
                        newPos -= scrollSize;
                    }
                    _scrollObj[_dir] = newPos;
                } else {
                    var newPos = _scrollObj[_dir] - opts.scrollAmount;
                    if (newPos <= 0) {
                        newPos += scrollSize;
                    };
                    _scrollObj[_dir] = newPos;
                };
            };

            //ʼ
            var moveId = setInterval(scrollFunc, opts.scrollDelay);

            //껮ֹͣ
            $marquee.hover(function () {
                clearInterval(moveId);
            }, function () {
                clearInterval(moveId);
                moveId = setInterval(scrollFunc, opts.scrollDelay);
            });
            var go = true;
            $marquee.click(function () {
                if (go) {
                    clearInterval(moveId);
                    go = false;
                }
                else {
                    moveId = setInterval(scrollFunc, opts.scrollDelay);
                    go = true;
                }
            })
        });
    };

    $.fn.aliziMarquee.defaults = {
        isEqual: true,		//йԪسǷ,true,false
        loop: 0,			//ѭ0ʱ
        direction: "left",	//"left","right","up","down"
        scrollAmount: 1,		//
        scrollDelay: 20		//ʱ

    };

    $.fn.aliziMarquee.setDefaults = function (settings) {
        $.extend($.fn.aliziMarquee.defaults, settings);
    };
})(jQuery);

});